function cb_m51
% Menu 52
% Display Z
 
  global f  
  global sfontsize 
  global persParamsDir   
  global puzFname
  global puDataDir  
  global hdt
  global m51
  
  capt = get(m51,'label');   
  
  [fname, fpath, fltidx] = uigetfile({'*.puz','Open a PUZ - file'}, ...
                           capt,strcat(puDataDir,puzFname));
  
  if fltidx > 0
   
   cancelMeasurement; 
    
    puzFname=fname;    
    puDataDir=fpath;
    sn = strcat(persParamsDir,'puDirFname.mat');
    save('-mat',sn,'puDataDir', 'puzFname');  
    
    loadname=strcat(puDataDir,puzFname);
    planename=strrep(puzFname,'.puz','');    
    titlename=[planename,': Z / \Omega'];
    
    load(loadname,'-mat');
    
    L=20*log10(abs(Z));    
    P=180/pi*angle(Z); 
     
    if ishandle(hdt) 
        delete(hdt) 
    end;
    
    fa=f(1);
    fb=f(end);
    
    subplot(2,1,1)
    
    semilogx(f,L)
    axis([fa fb 55 125])
    grid
    title(titlename);
    xlabel('Frequency / Hz')
    ylabel('Gain / dB')
    ha1=gca;
    
    subplot(2,1,2)    
    semilogx(f,P)
    axis([fa fb -100 100]);
    grid
    xlabel('Frequency / Hz')
    ylabel('Phase / degree') 
    ha2=gca;
  
    set(ha1, 'fontsize',sfontsize);   
    set(ha2, 'fontsize',sfontsize); 
    
  end
  
end
